-- Table: belasteter_standort

-- DROP TABLE belasteter_standort;

CREATE TABLE belasteter_standort
(
  katasternummer text NOT NULL,
  url_standort text,
  inbetrieb boolean,
  nachsorge boolean,
  ersteintrag text NOT NULL,
  letzteanpassung text NOT NULL,
  url_kbs_auszug text,
  zustaendigkeitkataster_fk text,
  xtf_id text NOT NULL,
  CONSTRAINT belasteter_standort_pkey PRIMARY KEY (xtf_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE belasteter_standort
  OWNER TO postgres;
  
-- Table: belasteter_standort_geo_lage_polygon

-- DROP TABLE belasteter_standort_geo_lage_polygon;

CREATE TABLE belasteter_standort_geo_lage_polygon
(
  xtf_id text NOT NULL,
  belasteter_standort text,
  geom geometry(Polygon,21781),
  CONSTRAINT belasteter_standort_geo_lage_polygon_pkey PRIMARY KEY (xtf_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE belasteter_standort_geo_lage_polygon
  OWNER TO postgres;
  
-- Table: belasteter_standort_geo_lage_punkt

-- DROP TABLE belasteter_standort_geo_lage_punkt;

CREATE TABLE belasteter_standort_geo_lage_punkt
(
  xtf_id text NOT NULL,
  belasteter_standort text,
  geom geometry(Point,21781),
  CONSTRAINT belasteter_standort_geo_lage_punkt_pkey PRIMARY KEY (xtf_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE belasteter_standort_geo_lage_punkt
  OWNER TO postgres;
  
-- Table: rel_untersmassn

-- DROP TABLE rel_untersmassn;

CREATE TABLE rel_untersmassn
(
  value text NOT NULL,
  bag_in_belasteter_standort text NOT NULL
)
WITH (
  OIDS=FALSE
);
ALTER TABLE rel_untersmassn
  OWNER TO postgres;

-- Table: untersuchungsmassnahmen_definition

-- DROP TABLE untersuchungsmassnahmen_definition;

CREATE TABLE untersuchungsmassnahmen_definition
(
  code text NOT NULL,
  text text,
  sprache text,
  xtf_id text NOT NULL
)
WITH (
  OIDS=FALSE
);
ALTER TABLE untersuchungsmassnahmen_definition
  OWNER TO postgres;
  
-- Table: zustaendigkeitkataster

-- DROP TABLE zustaendigkeitkataster;

CREATE TABLE zustaendigkeitkataster
(
  url_behoerde text,
  url_kataster text,
  bemerkung text,
  xtf_id text NOT NULL,
  CONSTRAINT zustaendigkeitkataster_pkey PRIMARY KEY (xtf_id)
)
WITH (
  OIDS=FALSE
);
ALTER TABLE zustaendigkeitkataster
  OWNER TO postgres;